﻿using System;
using System.IO;
using System.Reflection;

namespace HorribleOfficeInterop
{
    class Program
    {
        // Listing 1.3. Koszmar współdziałania z pakietem Office we wcześniejszych wersjach C#
        static void Main(string[] args)
        {
            var wordApp = new Microsoft.Office.Interop.Word.Application();
            object fileName = Path.Combine(
                // Niewielka zmiana w porównaniu z kodem przykładu zamieszczonym
                // w książce, która ma związek z tym, że niektóre wersje 
                // pakietu Office będą domyślnie przeszukiwać bibliotek 
                // w katalogu c:\Windows\System32.
                Directory.GetCurrentDirectory(),
                @"WordFile.docx");
            object missing = System.Reflection.Missing.Value;
            object readOnly = true;
            Microsoft.Office.Interop.Word._Document doc =
                wordApp.Documents.Open(ref fileName, ref missing, ref readOnly,
                    ref missing, ref missing, ref missing, ref missing, ref missing,
                    ref missing, ref missing, ref missing, ref missing, ref missing,
                    ref missing, ref missing, ref missing);
            object docProperties = doc.BuiltInDocumentProperties;
            Type docPropType = docProperties.GetType();
            object authorProp = docPropType.InvokeMember("Item",
                BindingFlags.Default | BindingFlags.GetProperty,
                null, docProperties,
                new object[] { "Author" });
            Type propType = authorProp.GetType();
            string authorName = propType.InvokeMember("Value",
                BindingFlags.Default | BindingFlags.GetProperty,
                null, authorProp,
                new object[] { }).ToString();
            object saveChanges = false;
            doc.Close(ref saveChanges, ref missing, ref missing);
            Console.WriteLine(authorName);
        }
    }
}
